clear;close all;clc;

%% Load Korea CPI
tempData = readtable('Data/Components of real exchange rate movements.xlsx', 'Sheet', 'Engel exercise');
%% Compute n differences and MSE
tempData2 = tempData(:,16:18);
tempData2(:,1) = 0.58 .* tempData2(:,1) ; % correction from Maury
variableNames = tempData2.Properties.VariableNames;

% Number of rows in the table
numRows = height(tempData2);
MSE_struct = struct();
% Loop through each variable
for varIndex = 1:length(variableNames)
    varName = variableNames{varIndex};
    
    % Initialize an array to hold MSE values for the current variable
    MSE_array = zeros(96, 1);
    
    % Loop from n = 1 to 96
    for n = 1:96
        % Create the lagged version of the variable
        laggedData = lagmatrix(tempData2.(varName), n);
        
        % Compute the n-th difference
        diffData = tempData2.(varName) - laggedData;
        
        % Create the new variable name
        newVarName = sprintf('%s_diff%d', varName, n);
        
        % Add the new variable to the table
        tempData2.(newVarName) = diffData;
        
        % Compute MSE, ignoring NaN values
        validData = diffData(~isnan(diffData));
        MSE = mean(validData .^ 2);  % Mean Squared Error
        MSE_array(n) = MSE;
    end
    
    % Add the MSE array to the structure
    MSE_struct.(sprintf('%s_MSE', varName)) = MSE_array;
end


%% Internal/External Price Calculation and Plot
MSE_table = table();
MSE_table.diff = (1:96)';
MSE_table.internal = MSE_struct.Balassa_SamuelsonTerm_MSE./ ( MSE_struct.Balassa_SamuelsonTerm_MSE + MSE_struct.RelativeTradablesTerm_MSE);
MSE_table.external = MSE_struct.RelativeTradablesTerm_MSE./ ( MSE_struct.Balassa_SamuelsonTerm_MSE + MSE_struct.RelativeTradablesTerm_MSE);

%% Save to Excel
% Specify the file name
fileName = 'Data/Engel_exercise.xlsx';

% Write the table to an Excel file
writetable(tempData2, fileName);
writetable(MSE_table, fileName, 'Sheet', 'internal_external');